{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 27.01.99 - 20:16:39 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  ShellAPI,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Buttons,
  ComCtrls,
  StdCtrls,
  ExtCtrls,
  Menus,
  MMSystem,
  MMUtils,
  MMAbout,
  MMObj,
  MMDSPObj,
  MMWaveIO,
  MMMPType,
  MMMPEG,
  MMDesign,
  MMWavOut,
  MMDIBCv,
  MMLevel,
  MMConect,
  MMSpectr,
  MMHTimer,
  MMSlider,
  MMLEDS,
  MMPanel,
  MMSpin,
  MMLEDLbl,
  MMButton,
  MMWave,
  MMLabel,
  MMHook, MMPitch, MMAudio, BusinessSkinForm, MMVolume, MMRingBf;

type
  Tmainplayer = class(TForm)
    OpenDialog: TOpenDialog;
    WaveOut: TMMWaveOut;
    MMDesigner1: TMMDesigner;
    MMConnector1: TMMConnector;
    HiTimer: TMMHiTimer;
    MMPanel2: TMMPanel;
    ButtonPanel: TMMPanel;
    btnStop: TMMSpeedButton;
    btnPlay: TMMSpeedButton;
    btnPause: TMMSpeedButton;
    btnOpen: TMMSpeedButton;
    btnPrev: TMMSpeedButton;
    btnSkipL: TMMSpeedButton;
    btnSkipR: TMMSpeedButton;
    btnNext: TMMSpeedButton;
    btnMenu: TMMSpeedButton;
    btnIncVolume: TMMSpeedButton;
    btnDecVolume: TMMSpeedButton;
    Bevel1: TBevel;
    btnPlayList: TMMSpeedButton;
    Bevel2: TBevel;
    PopupMenu: TPopupMenu;
    Preferences1: TMenuItem;
    N1: TMenuItem;
    Play1: TMenuItem;
    Stop1: TMenuItem;
    Pause1: TMenuItem;
    N2: TMenuItem;
    Previous1: TMenuItem;
    Next1: TMenuItem;
    N3: TMenuItem;
    PlayList1: TMenuItem;
    N4: TMenuItem;
    Info1: TMenuItem;
    fadeTimer: TMMHiTimer;
    mpegfile: TMMAudioFile;
    pitch: TMMPitch;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure HiTimerTimer(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnOpenClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnPrevClick(Sender: TObject);
    procedure btnSkipLClick(Sender: TObject);
    procedure btnSkipRClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure btnDecVolumeClick(Sender: TObject);
    procedure btnIncVolumeClick(Sender: TObject);
    procedure btnPlayListClick(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure MMPanelMouseDown(Sender: TObject; Button: TMouseButton;
                               Shift: TShiftState; X, Y: Integer);

    procedure MMPanelMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure MMPanelMouseUp(Sender: TObject; Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
    procedure GaugeMouseDown(Sender: TObject; Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnMenuClick(Sender: TObject);
    procedure PopupMenuPopup(Sender: TObject);
    procedure PreferencesClick(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure WaveOutPause(Sender: TObject);
    procedure WaveOutRestart(Sender: TObject);
    procedure fadeTimerTimer(Sender: TObject);
  public
    oMin, oSec,oHr: Word;
    Dragging: Boolean;
    DragStart: TPoint;

    Seeking: Boolean;
    OldTime,CurTime: Longint;

    PlayListName: TFileName;
    IncPlayList: Boolean;

    DisplayColor: TColor;

    TimeCnt : Longint;

    procedure LoadImage(Image: TImage; Name: PChar);
    procedure DrawTime(Time: Longint);
    procedure SetFileParams;
    function  LoadFile(FileName: TFileName): Boolean;
    function  AddFile(FileName: TFileName): Boolean;
    procedure SelectFile(index: integer);
    procedure WMNCHitTest(var Msg: TWMNCHitTest); message WM_NCHitTest;
    procedure WMDropFiles(var Msg: TMessage); message WM_DropFiles;
    procedure LoadSettings;
    procedure SaveSettings;

    procedure DrawLevelBar(Sender: TObject; DIB: TMMDIBCanvas; Rect: TRect; nSpots,Peak: integer);
  end;

var
  mainplayer: Tmainplayer;

implementation

{$R *.DFM}
{$R IMAGE.RES}

uses unit2,form_mainform, Form_playlist;
var fadein,fadeout:boolean;

const
    REGBASENAME =  'Software\SwiftSoft\MPEGPlay';

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.WMNCHitTest(var Msg: TWMNCHitTest);
begin
   inherited;                       { is the click in the client area?   }
   if (Msg.Result = htClient) then  { if so, make Windows think it's     }
       Msg.Result := htCaption;     { on the caption bar.                }
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.LoadImage(Image: TImage; Name: PChar);
begin
   with Image.Picture do
   begin
      { load the bitmap }
      Bitmap.Handle := LoadBitmap(hInstance,Name);
      { change the black/white resource to a colored bitmap }
      ChangeColors(Bitmap,False,DisplayColor,clBlack,clBlack);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.LoadSettings;
var
   L,T: integer;
begin
   try
      L := (Screen.Width-Width) div 2;
      T := (Screen.Height-Height) div 2;
      Left := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Left', L);
      Top  := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Top', T);
      WaveOut.NumBuffers := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Buffers', WaveOut.NumBuffers);
      WaveOut.BufferSize := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'BufferSize', WaveOut.BufferSize);
      WaveOut.DeviceID := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'DeviceID', WaveOut.DeviceID);
      WaveOut.CallBackMode := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'CBMode', WaveOut.CallBackMode);
   except
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.SaveSettings;
begin
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Left', Left);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Top', Top);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Buffers', WaveOut.NumBuffers);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'BufferSize', WaveOut.BufferSize);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'DeviceID', WaveOut.DeviceID);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'CBMode', WaveOut.CallBackMode);
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.FormCreate(Sender: TObject);
begin
   fadein:=false;fadeout:=false;

{
   mainform.MMLevel1.DIBCanvas.BackGroundBitmap.LoadFromResourceName(hInstance,'BM_BAR1');
   mainform.MMLevel2.DIBCanvas.BackGroundBitmap.LoadFromResourceName(hInstance,'BM_BAR1');
   mainform.MMSpectrum1.DIBCanvas.BackGroundBitmap.LoadFromResourceName(hInstance,'BM_BAR2');
   mainform.MMLevel1.DIBCanvas.PaletteRealize := True;
   mainform.MMLevel2.DIBCanvas.PaletteRealize := True;
   mainform.MMSpectrum1.DIBCanvas.PaletteRealize := True;

   DragAcceptFiles(Handle,True);

   PlayListName := 'noname.m3u';
   PlayList  := TStringList.Create;
   PlayIndex := 0;

   DisplayColor := clLime;
   LoadImage(mainform.ImageEOF,'BM_EOF');
   LoadImage(mainform.ImageState,'BM_PLAY');

   LoadSettings;

   mainform.MMLevel1.OnDrawBar := DrawLevelBar;
   mainform.MMLevel2.OnDrawBar := DrawLevelBar;
   mainform.MMSpectrum1.OnDrawBar := DrawLevelBar;
  }
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.FormDestroy(Sender: TObject);
begin
   //PlayList.Free;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   IncPlayList := False;
   WaveOut.Close;
   SaveSettings;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.FormShow(Sender: TObject);
begin
   if (ParamStr(1) <> '') then
      if LoadFile(ParamStr(1)) then
      begin
         btnPlayClick(nil);
      end
      else MessageDlg(ParamStr(1)+' is not a valid Audiofile',mtError, [mbOK],0);
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.WMDropFiles(var Msg: TMessage);
var
   i,cnt: integer;
   Buf: array[0..255]of Char;

begin
  {
   try
      cnt := DragQueryFile(Msg.wParam,$FFFFFFFF,@Buf,255);
      if (cnt > 0) then
      begin
         IncPlayList := False;
         WaveOut.Stop;
         PlayList.Clear;
         for i := 0 to cnt-1 do
         begin
            DragQueryFile(Msg.wParam,i,@Buf,255);
            if not AddFile(StrPas(Buf)) then
               MessageDlg(StrPas(Buf)+' is not a valid Audiofile',mtError, [mbOK],0);
         end;

         SelectFile(playlistindex);
         if (PlayList.Count > 0) then btnPlayClick(nil);
      end;

   finally
      DragFinish(Msg.wParam);
   end;
   }
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.DrawTime(Time: Longint);
Var
   Hour, Min, Sec, MSec: Word;

begin
   { Display the "Time" }
   TimeDecode(Time, Hour, Min, Sec, MSec);

   if (oHr <> Hour) then
   begin
      mainform.hh1.Value := Hour;
      oHr := Hour;
   end;

   if (oSec <> Sec) then
   begin
      mainform.ss1.Value := Sec;
      oSec := Sec;
   end;

   if (oMin <> Min) then
   begin
      mainform.mm1.Value := Min;
      oMin := Min;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.SetFileParams;
begin
   if not MpegFile.Empty then
   with MpegFile do
   begin
      mainform.ss1.Enabled  := True;
      mainform.ss2.Enabled  := True;
      mainform.mm1.Enabled  := True;
      mainform.mm2.Enabled  := True;
      mainform.hh1.Enabled  := True;
      mainform.hh2.Enabled  := True;
      mainform.digit.Enabled:= True;
      mainform.digit2.Enabled:= True;

      mainform.lblFile.Caption :=UpperCase(ExtractFileName(mpegfile.Filename));
      mainform.ledRate.Value   := SampleRate div 1000;
      mainform.ledRate.Enabled := True;

      mainform.lblLayer.Visible  := True;
      mainform.lblLayer2.Visible := True;
      case  MpegFile.MpegTrailingHeader of
          1: mainform.lblLayer2.Caption := 'I';
          2: mainform.lblLayer2.Caption := 'II';
          3: mainform.lblLayer2.Caption := 'III';
      end;

      if (MpegFile.Channels = 0) or (MpegFile.Channels = 1) then
         mainform.ledMode.Mode := mStereo
      else
         mainform.ledMode.Mode := mMono;
         mainform.ledMode.Enabled := True;

      mainform.ledBitRate.Value := BitRate;
      mainform.ledBitRate.Enabled := True;
      mainform.lblBitRate.Caption := 'KBit/s';
   end else
   {
   else if not WaveFile.Wave.Empty then
   with WaveFile.Wave do
   begin
      mainform.ss1.Enabled  := True;
      mainform.ss2.Enabled  := True;
      mainform.mm1.Enabled  := True;
      mainform.mm2.Enabled  := True;
      mainform.digit.Enabled:= True;

      mainform.lblFile.Caption := UpperCase(ExtractFileName(mpegfile.FileName));
      mainform.ledRate.Value   := SampleRate div 1000;
      mainform.ledRate.Enabled := True;

      mainform.lblLayer.Visible  := False;
      mainform.lblLayer2.Visible := False;

      mainform.ledMode.Mode := Mode;
      mainform.ledMode.Enabled := True;

      mainform.ledBitRate.Value := BitLength;
      mainform.ledBitRate.Enabled := True;
      mainform.lblBitRate.Caption := 'Bit';
   end }
   begin
      mainform.ss1.Enabled  := False;
      mainform.ss2.Enabled  := False;
      mainform.mm1.Enabled  := False;
      mainform.mm2.Enabled  := False;
      mainform.hh1.Enabled  := False;
      mainform.hh2.Enabled  := False;
      mainform.digit.Enabled:= False;
      mainform.digit2.Enabled:= False;

      mainform.lblFile.Caption   := 'NO FILE';
      mainform.ledRate.Enabled   := False;
      mainform.lblLayer.Visible  := False;
      mainform.lblLayer2.Visible := False;
      mainform.ledMode.Enabled   := False;
      mainform.ledBitRate.Enabled:= False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.HiTimerTimer(Sender: TObject);
var
   Time: Longint;
begin
   MMConnector1.Trigger;
   inc(TimeCnt);

   if (TimeCnt mod 5 = 0) and (wosPlay in Waveout.State) and not Seeking then
   begin
      Time := mpegfile.Position;
      inc(CurTime,Time-OldTime);
      if activeplayer=2 then
         DrawTime(MpegFile.FileLength-CurTime);
      OldTime := Time;

      if not MpegFile.Empty then
      begin
         mainform.Gauge.Value := MulDiv(MpegFile.Position, 100, MpegFile.FileLength);
         mainform.ImageEOF.Visible := MpegFile.Position >= MpegFile.FileLength;
      end;
      {
      else
      begin
         mainform.Gauge.Value := MulDiv(WaveFile.Wave.Position, 100, WaveFile.Wave.DataSize);
         mainform.ImageEOF.Visible := WaveFile.Wave.Position >= WaveFile.Wave.DataSize;
      end;
      }
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.WaveOutStart(Sender: TObject);
begin
   TimeCnt := 0;
   hitimer.enabled := false;
   HiTimer.Enabled := True;
   LoadImage(mainform.ImageState,'BM_PLAY');
   mainform.ImageState.Visible := True;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.WaveOutStop(Sender: TObject);
begin
   HiTimer.Enabled := False;
   WaveOut.Close;
   Seeking := False;
   if activeplayer=2 then
      DrawTime(0);
   mainform.Gauge.Value := 0;
   mainform.ImageEOF.Visible := False;
   mainform.ImageState.Visible := False;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.WaveOutPause(Sender: TObject);
begin
   LoadImage(mainform.ImageState,'BM_PAUSE');
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.WaveOutRestart(Sender: TObject);
begin
   LoadImage(mainform.ImageState,'BM_PLAY');
end;

{-- TMainForm -----------------------------------------------------------}
function Tmainplayer.LoadFile(FileName: TFileName): Boolean;
begin
  {
   Result := False;
   if (FileName <> '') and FileExists(FileName) then
   begin
      PlayIndex := 0;
      PlayList.Clear;
      MpegFile.FileName := '';
      WaveFile.Wave.FileName := '';

      if IsMpegFile(FileName) or wioIsWaveFile(FileName, RIFF_FILE) then
      begin
         PlayListName := 'noname.m3u';
         PlayList.Add(FileName);
      end
      else
      begin
         PlayListName := FileName;
         LoadPlayList(FileName,PlayList);
      end;

      Result := (PlayList.Count > 0);

      SelectFile(0);
   end;
   }
end;

{-- TMainForm -----------------------------------------------------------}
function Tmainplayer.AddFile(FileName: TFileName): Boolean;
begin
  {
   Result := False;
   if (FileName <> '') and FileExists(FileName) then
   begin
      if IsMpegFile(FileName) or wioIsWaveFile(FileName, RIFF_FILE) then
      begin
         PlayList.Add(FileName);
         Result := True;
      end
      else
      begin
         Result := LoadPlayList
          (FileName,PlayList);
      end;
   end;
   }
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.SelectFile(index: integer);
var
   FileName: TFileName;
begin
   MpegFile.FileName := '';
   //WaveFile.Wave.FileName := '';

   if (fileexists(playlist.Playlistgrid.Cells[5,PlayListindex])) then
   begin
      FileName := playlist.Playlistgrid.Cells[5,PlayListindex];
      if (FileName <> '') and FileExists(FileName) then
      begin
         if IsMpegFile(FileName) then
         begin
            MpegFile.FileName := FileName;
            WaveOut.Input := MpegFile;
         end;
         {
         else if wioIsWaveFile(FileName, RIFF_FILE) then
         begin
            WaveFile.Wave.FileName := FileName;
            WaveOut.Input := WaveFile;
         end
         }
      end;
      CurTime := 0;
      OldTime := 0;
   end;
   SetFileParams;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.PopupMenuPopup(Sender: TObject);
begin
   { adjust menu entrys }
{   PopupMenu.Items[6].Enabled := PlayList.Count > 1;
   PopupMenu.Items[7].Enabled := PlayList.Count > 1;

   if (wosPlay in WaveOut.State) then
   begin
      PopupMenu.Items[0].Enabled := False;
      PopupMenu.Items[2].Caption := '&Restart';
      PopupMenu.Items[3].Enabled := True;
      PopupMenu.Items[4].Enabled := True;
   end
   else
   begin
      PopupMenu.Items[0].Enabled := True;
      PopupMenu.Items[2].Caption := '&Play';
      PopupMenu.Items[3].Enabled := False;
      PopupMenu.Items[4].Enabled := False;
   end;

   if (wosPause in WaveOut.State) then
      PopupMenu.Items[3].Caption := '&UnPause'
   else
      PopupMenu.Items[3].Caption := '&Pause';
}
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.PreferencesClick(Sender: TObject);
begin
   with TPreferencesForm.Create(Self) do
   try
      ShowModal;
   finally
      Free;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnOpenClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      IncPlayList := False;
      WaveOut.Stop;

      if not LoadFile(OpenDialog.FileName) then
         MessageDlg('This is not a valid Audiofile',mtWarning, [mbOK],0);

      SetFileParams;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnCloseClick(Sender: TObject);
begin
   Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnMenuClick(Sender: TObject);
var
   P: TPoint;
begin
   P := ButtonPanel.ClientToScreen(Point(btnMenu.Left,btnMenu.Top+btnMenu.Height));
   PopupMenu.Popup(P.X,P.Y);
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnPlayClick(Sender: TObject);
begin
  if mainform.Label_onair.Caption='PAUSE' then btnPause.OnClick(Self) else
  begin
    if (playlistindex > 0) then
    begin
         mpegfile.FadeInDuration:=1000;
         WaveOut.Stop;
         mainform.Label_onair.Caption:='ON AIR';
         if mainform.fadein.Value=0 then mpegfile.Volume:=mainform.vol_global.Value else
            mpegfile.Volume:=0;
         fadein:=true;
         fadeout:=false;

         SelectFile(PlaylistIndex);
         WaveOut.Start;
    end;
  end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnPauseClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      if (wosPause in WaveOut.State) then
      begin
         fadeout:=false;
         mpegfile.Volume:=0;
         fadein:=true;
         waveout.Reset;
         WaveOut.Restart;
         mainform.Label_onair.Caption:='ON AIR';
      end else
      begin
         mainform.Label_onair.Caption:='PAUSE';
         fadeout:=true;
         fadein:=false;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnStopClick(Sender: TObject);
begin
   fadeout:=true;
   fadein:=false;
   mainform.Label_onair.Caption:='OFF AIR';
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnPrevClick(Sender: TObject);
begin
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnNextClick(Sender: TObject);
begin
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.GaugeMouseDown(Sender: TObject; Button: TMouseButton;
                                   Shift: TShiftState; X, Y: Integer);
var
   aPos: Longint;

begin
   if (wosOpen in WaveOut.State) then
   begin
      Seeking := True;
      WaveOut.Pause;
      if not MpegFile.Empty then
      begin
          with mainform.Gauge do
          aPos := MulDiv(X-BevelExtend,MpegFile.FileLength,(Width-2*BevelExtend)-1);
          if aPos >= MpegFile.FileLength then
          begin
             WaveOut.Stop;
             exit;
          end
          else
          begin
             MpegFile.Position := aPos;
             CurTime := MpegFile.Position*60;
          end;
      end;
      {
      else
      begin
          with mainform.Gauge do
          aPos := MulDiv(X-BevelExtend,WaveFile.Wave.DataSize,(Width-2*BevelExtend)-1);
          if aPos > WaveFile.Wave.DataSize then
          begin
             WaveOut.Stop;
             exit;
          end
          else
          begin
             WaveFile.Wave.Position := aPos;
             CurTime := WaveFile.Wave.Position;
          end;
      end;
      }
      WaveOut.Reset;
      WaveOut.Restart;
      OldTime := 0;
      Seeking := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnSkipLClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      Seeking := True;
      WaveOut.Pause;
      if not MpegFile.Empty then
      begin
         MpegFile.Position := MpegFile.Position-(5000 div 60);
         CurTime := MpegFile.Position*60;
      end;
      {
      else
      begin
         WaveFile.Wave.Position := WaveFile.Wave.Position-5000;
         CurTime := WaveFile.Wave.Position;
      end;
      }
      WaveOut.Reset;
      WaveOut.Restart;
      OldTime := 0;
      Seeking := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnSkipRClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      if not MpegFile.Empty then
      begin
         if MpegFile.Position+(5000 div 60) > MpegFile.FileLength then
            WaveOut.Stop;
      end;
      {
      else
      begin
         if WaveFile.Wave.Position+5000 > WaveFile.Wave.DataSize then
            WaveOut.Stop;
      end;
      }
      Seeking := True;
      WaveOut.Pause;
      if not MpegFile.Empty then
      begin
         MpegFile.Position := MpegFile.Position+(5000 div MpegFile.FileLength);
         CurTime := MpegFile.Position*60;
      end;
      {
      else
      begin
         WaveFile.Wave.Position := WaveFile.Wave.Position+5000;
         CurTime := WaveFile.Wave.Position;
      end;
      }
      WaveOut.Reset;
      WaveOut.Restart;
      OldTime := 0;
      Seeking := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnDecVolumeClick(Sender: TObject);
var
   Volume,L,R: Longint;
begin
   if (wosOpen in WaveOut.State) then
   begin
      WaveOutGetVolume(WaveOut.Handle,@Volume);
      L := LoWord(Volume);
      R := HiWord(Volume);

      L := Max(L - 5000,0);
      R := Max(R - 5000,0);

      Volume := (R shl 16) + L;
      WaveOutSetVolume(WaveOut.Handle,Volume);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnIncVolumeClick(Sender: TObject);
var
   Volume,L,R: Longint;
begin
   if (wosOpen in WaveOut.State) then
   begin
      WaveOutGetVolume(WaveOut.Handle,@Volume);
      L := LoWord(Volume);
      R := HiWord(Volume);

      L := Min(L + 5000,$FFFF);
      R := Min(R + 5000,$FFFF);

      Volume := (R shl 16) + L;
      WaveOutSetVolume(WaveOut.Handle,Volume);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.btnPlayListClick(Sender: TObject);
var
   wasPlaying: Boolean;
begin
   {
   with TPlayListEditor.Create(Self) do
   try
      if ShowModal = mrOK then
      begin
         IncPlayList := False;
         wasPlaying := (wosPlay in WaveOut.State);
         WaveOut.Stop;
         PlayList.Assign(TempPlayList);
         PlayListName := ListName;
         PlayIndex := 0;
         SelectFile(0);
         if wasPlaying then btnPlayClick(nil);
      end;

   finally
      Free;
   end;
   }
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.MMPanelMouseDown(Sender: TObject; Button: TMouseButton;
                                     Shift: TShiftState; X, Y: Integer);
begin
   if (Button = mbLeft) then
   begin
      Dragging := True;
      DragStart := TControl(Sender).ClientToScreen(Point(X,Y));
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.MMPanelMouseUp(Sender: TObject; Button: TMouseButton;
                                   Shift: TShiftState; X, Y: Integer);
begin
   if (Button = mbLeft) then Dragging := False;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.MMPanelMouseMove(Sender: TObject; Shift: TShiftState;
                                     X, Y: Integer);
var
   Diff: TPoint;
begin
   if Dragging then
   begin
      Diff := TControl(Sender).ClientToScreen(Point(X,Y));
      Diff := Point(Diff.X-DragStart.X,Diff.Y-DragStart.Y);
      SetBounds(Left+Diff.X,Top+Diff.Y,Width,Height);
      DragStart.X := DragStart.X+Diff.X;
      DragStart.Y := DragStart.Y+Diff.Y;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.Info1Click(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TMainForm -----------------------------------------------------------}
procedure Tmainplayer.DrawLevelBar(Sender: TObject; DIB: TMMDIBCanvas; Rect: TRect; nSpots,Peak: integer);
begin
   with DIB,Rect do
   begin
      if Sender = mainform.MMSpectrum1 then
      begin
         DIB_CopyDIBBits(mainform.MMSpectrum1.DIBCanvas.BackSurface,Left,Bottom-nSpots,Right-Left-1,Bottom,0,Bottom-nSpots);
         DIB_CopyDIBBits(mainform.MMSpectrum1.DIBCanvas.BackSurface,Left,Bottom-Peak,Right-Left-1,2,0,Bottom-Peak);
      end
      else if Sender = mainform.MMLevel1 then
      begin
         DIB_SetTColor(mainform.MMLevel1.Color);
         DIB_Clear;
         DIB_CopyDIBBits(mainform.MMLevel1.DIBCanvas.BackSurface,0,Top,2*nSpots,Bottom,0,0);
         DIB_CopyDIBBits(mainform.MMLevel1.DIBCanvas.BackSurface,2*Peak-2,Top,2,Bottom,2*Peak,0);
      end
      else
      begin
         DIB_SetTColor(mainform.MMLevel2.Color);
         DIB_Clear;
         DIB_CopyDIBBits(mainform.MMLevel2.DIBCanvas.BackSurface,0,Top,2*nSpots,Bottom,0,0);
         DIB_CopyDIBBits(mainform.MMLevel2.DIBCanvas.BackSurface,2*Peak-2,Top,2,Bottom,2*Peak,0);
      end;
   end;
end;

procedure Tmainplayer.fadeTimerTimer(Sender: TObject);
begin
  //if mpegfile.Position=mpegfile.FileLength-100 then delay:=True;
  //mainform.SOCIAL.Caption:=IntToStr(mpegfile.FileLength-mpegfile.Position);

  if fadeout=true then
  begin
    if mpegfile.Volume >0 then mpegfile.Volume:=mpegfile.Volume-(mainform.vol_global.Value div mainform.fadeout.Value) else
    begin
      if mainform.Label_onair.Caption='PAUSE' then WaveOut.Pause else
      begin
        WaveOut.Stop;
        fadeout:=false;
        mainform.settimeup(playlistindex);
      end;
    end;
  end;

  if fadein=true then
  begin
    if mainform.fadein.Value>0 then
    begin
      if mpegfile.Volume <=mainform.vol_global.Value then mpegfile.Volume:=mpegfile.Volume+(mainform.vol_global.Value div mainform.fadein.Value) else
      begin
        fadein:=false;
      end;
    end else
    begin
      mpegfile.Volume:=mainform.vol_global.Value;
      fadein:=false;
    end;
  end;

  //mainform.btn_playlist.Caption:=inttostr(mpegfile.Volume);
end;

end.
